/*
 * Decompiled with CFR 0.152.
 */
package frc.input;

import frc.input.JInputComponent;
import frc.input.JInputController;
import java.awt.Component;
import java.awt.Window;
import javax.swing.JOptionPane;

public class JInputDetector {
    private static final float THRESHOLD_RELATIVE = 35.0f;
    private static final float THRESHOLD_ABSOLUTE = 0.95f;
    private JInputComponent detected;
    private Thread worker;
    private boolean abort;

    public void detectButton(Window window, JInputController jInputController, JInputComponent[] jInputComponentArray) {
        this.detect(false, window, jInputController, jInputComponentArray);
    }

    public void detectAxis(Window window, JInputController jInputController, JInputComponent[] jInputComponentArray) {
        this.detect(true, window, jInputController, jInputComponentArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final JInputComponent getResult() {
        Thread thread = this.worker;
        synchronized (thread) {
            this.abort = true;
            return this.detected;
        }
    }

    private final void detect(final boolean bl, final Window window, final JInputController jInputController, final JInputComponent[] jInputComponentArray) {
        this.abort = false;
        this.detected = null;
        this.worker = new Thread(){

            public void run() {
                JInputDetector.this.detectImpl(bl, window, jInputController, jInputComponentArray);
            }
        };
        this.worker.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void detectImpl(boolean bl, Window window, JInputController jInputController, JInputComponent[] jInputComponentArray) {
        int n = jInputComponentArray.length;
        float[] fArray = new float[n];
        float[] fArray2 = null;
        float[] fArray3 = null;
        while (!this.abort && this.detected == null) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
            if (!JInputDetector.poll(window, jInputController, jInputComponentArray, fArray)) break;
            if (fArray2 == null) {
                fArray2 = new float[n];
                System.arraycopy(fArray, 0, fArray2, 0, n);
                if (bl) {
                    fArray3 = new float[n];
                    System.arraycopy(fArray, 0, fArray3, 0, n);
                }
            }
            JInputComponent jInputComponent = this.detected = bl ? this.checkAxis(jInputComponentArray, fArray, fArray2, fArray3) : this.checkButton(jInputComponentArray, fArray, fArray2);
        }
        Thread thread = this.worker;
        synchronized (thread) {
            if (!this.abort) {
                window.dispose();
            }
        }
    }

    private final JInputComponent checkButton(JInputComponent[] jInputComponentArray, float[] fArray, float[] fArray2) {
        int n = jInputComponentArray.length;
        while (n-- > 0) {
            if (fArray[n] == fArray2[n]) continue;
            return jInputComponentArray[n];
        }
        return null;
    }

    private final JInputComponent checkAxis(JInputComponent[] jInputComponentArray, float[] fArray, float[] fArray2, float[] fArray3) {
        int n = jInputComponentArray.length;
        while (n-- > 0) {
            float f = fArray[n];
            if (jInputComponentArray[n].isRelative()) {
                if (0.0f != fArray3[n]) {
                    fArray3[n] = 0.0f;
                    fArray2[n] = Math.abs(f);
                    continue;
                }
                int n2 = n;
                fArray2[n2] = fArray2[n2] + Math.abs(f);
                if (!(fArray2[n] >= 35.0f)) continue;
                return jInputComponentArray[n];
            }
            if (f < fArray2[n]) {
                fArray2[n] = f;
            }
            if (f > fArray3[n]) {
                fArray3[n] = f;
            }
            if (!(fArray3[n] - fArray2[n] >= 0.95f)) continue;
            return jInputComponentArray[n];
        }
        return null;
    }

    public static final boolean poll(Component component, JInputController jInputController, JInputComponent[] jInputComponentArray, float[] fArray) {
        if (JInputDetector.check(component, jInputController)) {
            if (fArray != null) {
                int n = jInputComponentArray.length;
                while (n-- > 0) {
                    fArray[n] = jInputComponentArray[n].getData();
                }
            }
            return true;
        }
        return false;
    }

    public static final boolean check(Component component, JInputController jInputController) {
        if (!jInputController.isAvailable()) {
            JOptionPane.showMessageDialog(component, "The selected controller has been unplugged", "Controller Unavailable", 2);
            return false;
        }
        if (!jInputController.poll()) {
            JOptionPane.showMessageDialog(component, "The selected controller cannot be polled", "Controller Unavailable", 2);
            return false;
        }
        return true;
    }
}

